/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.resource.ResourceAccessor;
import com.ferreusveritas.dynamictrees.api.resource.loading.AbstractResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.JoCodeResourcePreparer;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.JoCodeRegistry;
import com.ferreusveritas.dynamictrees.worldgen.RootsJoCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JoCodeResourceLoader
extends AbstractResourceLoader<List<String>> {
    private static final Logger LOGGER = LogManager.getLogger();

    public JoCodeResourceLoader() {
        super(new JoCodeResourcePreparer("jo_codes"));
    }

    @Override
    public void applyOnReload(ResourceAccessor<List<String>> resourceAccessor, ResourceManager resourceManager) {
        JoCodeRegistry.clear();
        resourceAccessor.getAllResources().forEach(resource -> this.registerCodes(resource.getLocation(), (List)resource.getResource()));
    }

    private void registerCodes(ResourceLocation location, List<String> lines) {
        Species species = TreeRegistry.findSpecies(location);
        lines.forEach(line -> this.registerCodeForLine(species, (String)line));
        LOGGER.debug("Successfully loaded JoCodes for species \"{}\".", (Object)location);
    }

    private void registerCodeForLine(Species species, String line) {
        String[] radiusAndCode = line.split(":");
        boolean isRoot = false;
        if (radiusAndCode[0].charAt(0) == '*') {
            radiusAndCode[0] = radiusAndCode[0].substring(1);
            isRoot = true;
        }
        this.registerCode(species, Integer.parseInt(radiusAndCode[0]), radiusAndCode[1], isRoot);
    }

    private void registerCode(Species species, int radius, String code, boolean root) {
        if (root) {
            RootsJoCode joCode = species.getRootsJoCode(code);
            joCode.setCareful(false);
            JoCodeRegistry.registerRoot(species.getRegistryName(), radius, joCode);
        } else {
            JoCode joCode = species.getJoCode(code).setCareful(false);
            JoCodeRegistry.register(species.getRegistryName(), radius, joCode);
        }
    }

    private void collectWorldGenCodes(Species species, int radius, JoCode joCode) {
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        ArrayList<String> arr = new ArrayList<String>();
        for (Direction dir : dirs) {
            arr.add(joCode.rotate(dir).toString());
        }
        Collections.sort(arr);
        LOGGER.debug(String.valueOf(species) + ":" + radius + ":" + (String)arr.get(0));
    }
}

